#include <maya/MPxFileTranslator.h>
#include <maya/MFnDagNode.h>
#include <maya/MGlobal.h>

#include <MDt.h>
#include <MDtExt.h>

#include "querymel.h"

bool
attributeExists(char *object, char *attribute)
{
    MString         command;
    MStringArray    result;
    MStatus         status;
    unsigned int    i;

    command = MString("listAttr ") + MString(object);

    status = MGlobal::executeCommand(command, result);

    if (status != MS::kSuccess)
    {
        return false;
    }
    
    for (i = 0; i < result.length(); i++)
    {
        if (strcmp(result[i].asChar(), attribute) == 0)
        {
            return true;
        }
    }
    return false;
}

char *
getQueryAsString(char *query, char *object, char *field, bool checkExists)
{
    MStringArray result;
    MStatus status;

    if (query && object && field)
    {
        MString command;
        
        if (checkExists && (attributeExists(object, field) == false))
        {
            return false;
        }
        
        command = MString(query) + MString(" ") + MString(object) + MString(".") + MString(field);

        status = MGlobal::executeCommand(command, result);

        if (status != MS::kSuccess)
        {
            return NULL;
        }

        if (result[0].length() == 0)
        {
            return NULL;
        }
        else
        {
            return (_strdup(result[0].asChar()));
        }
    }
    else
    {
        return NULL;
    }
}

bool
getQueryAsInt(char *query, char *object, char *field, int *resultVal, bool checkExists)
{    
    MIntArray result;
    MStatus status;

    if (query && object && field)
    {
        MString command;

        if (checkExists && (attributeExists(object, field) == false))
        {
            return false;
        }

        command = MString(query) + MString(" ") + MString(object) + MString(".") + MString(field);
 
        status = MGlobal::executeCommand(command, result);

        if (status != MS::kSuccess)
        {
            return false;
        }
 
        *resultVal = result[0];
        return true;
    }
    else
    {
        return false;
    }
}

bool
getQueryAsFloat(char *query, char *object, char *field, float *resultVal, bool checkExists)
{    
    MDoubleArray result;
    MStatus status;

    if (query && object && field)
    {
        MString command;
        
        if (checkExists && (attributeExists(object, field) == false))
        {
            return false;
        }

        command = MString(query) + MString(" ") + MString(object) + MString(".") + MString(field);

        status = MGlobal::executeCommand( command, result );

        if (status != MS::kSuccess)
        {
            return false;
        }

        *resultVal = (float) result[0];
        return true;
    }
    else
    {
        return false;
    }
}


bool
getConnectionQueryAsBool(MString field0, MString field1, bool *resultVal)
{
    MIntArray result;
    MStatus status;
    MString command;

    command = MString("isConnected ") + field0 + MString(" ") + field1;

    status = MGlobal::executeCommand( command, result );

    if (status != MS::kSuccess)
    {
        return false;
    }
    
    *resultVal = (result[0] == 0) ? false : true;
    return true;   
}

bool
getIntTagFromShape(int shape, char *tagName, int *val)
{
    char    *shapeName;
    bool    foundTag;

    DtShapeGetName(shape, &shapeName);

    foundTag = getQueryAsInt("getAttr", shapeName, tagName, val, true);

    if (foundTag == false)
    {
        MObject     trans;
        MStatus     stat;
        MDagPath    dagPath;

        DtExt_ShapeGetTransform(shape, trans);

        MFnDagNode fnTransNode(trans, &stat);
        stat = fnTransNode.getPath(dagPath);
    
        getQueryAsInt("getAttr", (char *)fnTransNode.fullPathName().asChar(), tagName, val, true);
    }

    return foundTag;
}

bool
getFloatTagFromShape(int shape, char *tagName, float *val)
{
    char    *shapeName;
    bool    foundTag;

    DtShapeGetName(shape, &shapeName);

    foundTag = getQueryAsFloat("getAttr", shapeName, tagName, val, true);

    if (foundTag == false)
    {
        MObject     trans;
        MStatus     stat;
        MDagPath    dagPath;
        
        DtExt_ShapeGetTransform(shape, trans);

        MFnDagNode fnTransNode(trans, &stat);
        stat = fnTransNode.getPath(dagPath);
    
        foundTag = getQueryAsFloat("getAttr", (char *)fnTransNode.fullPathName().asChar(), tagName, val, true);
    }

    return foundTag;
}

bool
getBoolTagFromShape(int shape, char *tagName, bool *val)
{
    char    *shapeName;
    bool    foundTag;

    DtShapeGetName(shape, &shapeName);

    foundTag = getQueryAsInt("getAttr", shapeName, tagName, (int *)val, true);

    if (foundTag == false)
    {
        MObject     trans;
        MStatus     stat;
        MDagPath    dagPath;
        
        DtExt_ShapeGetTransform(shape, trans);

        MFnDagNode fnTransNode(trans, &stat);
        stat = fnTransNode.getPath(dagPath);
    
        foundTag = getQueryAsInt("getAttr", (char *)fnTransNode.fullPathName().asChar(), tagName, (int *)val, true);
    }

    return foundTag;
}
